#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef USE_SYS_FT
#include <freetype2/ft2build.h>
#include <freetype/freetype.h>
#else
#include "ft2.h"
#endif

void fail(char* fmt, ...)
{
  va_list ap;
  fprintf(stderr,"fail: ");
  va_start(ap,fmt);
  vfprintf(stderr,fmt,ap);
  va_end(ap);
  fprintf(stderr,"\n");
  exit(1);
}

int main(int argc,char **argv)
{
  FT_Library ft;

  if (argc<2) fail("need font");
  if (FT_Init_FreeType(&ft))
      fail("freetype init");

  FT_Face face;
  if (FT_New_Face(ft, argv[1],0, &face)) fail("newface");
  FT_Set_Pixel_Sizes(face, 0, 20);
  
  FT_UInt gi;
  gi= FT_Get_Char_Index(face, 'A');
  if (!gi) fail("get_char_index");

  FT_Load_Glyph(face, gi, FT_LOAD_DEFAULT);

  int bbox_ymax = face->bbox.yMax / 64;
  int glyph_width = face->glyph->metrics.width / 64;
  int advance = face->glyph->metrics.horiAdvance / 64;
  int x_off = (advance - glyph_width) / 2;
  int y_off = bbox_ymax - face->glyph->metrics.horiBearingY / 64;

  if (FT_Render_Glyph(face->glyph, FT_RENDER_MODE_NORMAL))  fail("render");

#define iWID 200
#define iHEI 200
  unsigned char img[iWID*iHEI];

  int x= 10, y= 10;
  memset(img,0,sizeof(img));

  for (int i = 0; i < (int)face->glyph->bitmap.rows; i++)
    {
    int row_offset = y + i + y_off;
    for (int j = 0; j < (int)face->glyph->bitmap.width; j++)
      {
      unsigned char p =
        face->glyph->bitmap.buffer [i * face->glyph->bitmap.pitch + j];

      int ox= x+j+x_off;
      int oy= row_offset;
      if (ox>=0 && ox<iWID && oy>=0 && oy<iHEI)
         img[ ox+iWID*oy]= p;
      }
    }


   FILE *f;
   f= fopen("out.pgm","wb");
   fprintf(f, "P5\n%d %d\n255\n",iWID, iHEI);
   fwrite(img, 1, iWID*iHEI, f);
   fclose(f);

  FT_Done_FreeType(ft);
  return 0;
}